//list_demo.c
library "PToolboxLib"
include "Fctl.h"

#define FORM1 3000
#define LIST1 3001
#define BUTTON1 3002 
#define LIST2 3003
#define BUTTON2 3004
#define BUTTON3 3005

updateList(int listA, int listB) {
  int i;
  string item;

  i=FgetState(listA);
  if(i != -1) {
    item=FgetText(listA);
    FaddList(listB,1,&item); //add one item to listB
    FdelList(listA,i);
    FrevList(LIST1,0x01); //forward sort LIST1
    FrevList(LIST2,0x11); //reverse sort LIST2  
  }
}

main() {
  //When LISTHAND enabled: `s1=solid overline, `s2=dotted overline
  string names[5] = {"zebra","gazelle`s1","antelope","gnu`s2","muskox"}; 
  string results[5];
  string item;
  int e,i,len;
  clear();
    
  //create form
  Form(FORM1,"List Test");
  List(LIST1,5,20,60,5,0);
  FaddList(LIST1,5,names);
  FrevList(LIST1,0x01); //won't draw because form is not visible
  Button(BUTTON1,0,5,100,0,0,"Move->");
  List(LIST2,85,20,60,5,0);  
  Button(BUTTON2,0,102,100,0,0,"<-Move");
  Button(BUTTON3,0,2,145,0,0,"Done");
  Fctl(LISTHAND,LIST1);
  Fctl(LISTHAND,LIST2);
  Fctl(DRAW,FORM1);
  
  while(1) {
    e=Fevent(1);
    switch(e) {
    case BUTTON1: updateList(LIST1,LIST2); break;
    case BUTTON2: updateList(LIST2,LIST1); break;	
    case BUTTON3: 
      len=Fctl(LISTLEN,LIST1);
      FgetList(LIST1,results);
      puts("LIST1 length="+len+"\n");
      for(i=0;i<len;i++) puts(results[i]+"\n");
      
      len=Fctl(LISTLEN,LIST2);
      FgetList(LIST2,results);
      puts("LIST2 length="+len+"\n");
      for(i=0;i<len;i++) puts(results[i]+"\n");
      return;
    }
  }
}